﻿import xml.etree.ElementTree as exml
from io import BytesIO
from PySide2.QtCore import *
from PySide2.QtGui import *
from PySide2.QtWidgets import *
import pyside2uic

def LoadUiType(uiFile):
    # LoadUiType only accept ascii encoding chars
    uiFile = str(uiFile)
    parsed = exml.parse(uiFile)
    widget_class = parsed.find('widget').get('class')
    ui_class_name = parsed.find('class').text
    with open(uiFile, 'r') as f:
        o = BytesIO()
        frame = {}
        pyside2uic.compileUi(f, o)
        pyc = compile(o.getvalue(), '<string>', 'exec')
        exec pyc in frame
        ui_class = frame['Ui_%s' % ui_class_name]
        base_class = eval(widget_class)
    return ui_class, base_class
